import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class NeuronInputNode extends DrawObject
{
	// DrawObject abilities:
	@Override
	public boolean CanBeDeletedByUser()
	{
		return false;
	};

	@Override
	public boolean CanBeExcitedByUser()
	{
		return true;
	}

	@Override
	public boolean CanBeMovedByUser()
	{
		return false;
	}

	@Override
	public boolean CanBeSelectedByUser()
	{
		return false;
	}
	// end of DrawObject abilities

	public NeuronInputNode(Point Pos)
	{
		SetPosNoAlignOnGrid(Pos);
		SetSize(new Point(10, 10));
		InitializeExcitement(ExcitementOnceMilliseconds);
	};

	@Override
	protected void AddExcitementForNextTick(double ExcitementAdd)
	{
		ExcitementAddForNextTick += ExcitementAdd;
	};

	@Override
	protected void AfterCollectingAllExcitementForNextTick()
	{

	};

	@Override
	public void Draw(Graphics g)
	{
		if (!(IsWithinWindowBounds(this, 0)))
			return;

		// background (overdraw grid)
		if (IsHighlighted || IsPartOfMultiSelection)
			SetColor(g, Color.GREEN);
		else
			SetColor(g, Color.LIGHT_GRAY);
		FillRect(g, Pos.x, Pos.y, Size.x, Size.y);

		// frame
		SetColor(g, GetExcitementColor());
		DrawRect(g, Pos.x, Pos.y, Size.x, Size.y);
	}

	@Override
	protected void LoseExcitementAndAddExcitementForNextTick()
	{
		// validity (i.e. could appear in the real brain): the excitement shortly gets a spike...
		ExcitementCurrent += ExcitementAddForNextTick;

		ShiftExcitementHistory(ExcitementCurrent);

		// NeuronInputNode-specific:
		double ForwardedExcitement = LimitExcitement(ExcitementCurrent);

		((NeuronInputField) ExcitementPartner).ExciteAsPartner(ForwardedExcitement, this);
		// end of specific

		// validity: ...and then "collapses" again to basic level
		ExcitementCurrent -= ExcitementLossPerTick;

		// verify and reset
		ExcitementCurrent = LimitExcitement(ExcitementCurrent);
		ExcitementAddForNextTick = 0.0; // reset for next usage
	}

	@Override
	public void Move(Point MoveAmount)
	{
		SetPosNoAlignOnGrid(new Point(Pos.x + MoveAmount.x, Pos.y + MoveAmount.y));
	}
}
